#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//2D SmokeMod01.fsh  by    finalman  
//https://www.shadertoy.com/view/ls3XRl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.1415926535897932384626433832795;
const float TAU = 2.0 * PI;

mat2 rotate2D(float a)
{
    float c = cos(a);
    float s = sin(a);
    return mat2(
        c, -s,
        s, c
    );
}

float smokeBase(vec2 pos)
{
    float v = clamp(pos.x * 1.5, -1.0, 1.0);
    return 1.0 - exp(-cos(v * PI * 0.5) * smoothstep(0.0, -1.0, pos.y) * 3.0);
}

vec2 swirl(vec2 center, float angle, float radius, vec2 pos)
{
    pos -= center;
    angle *= exp(-length(pos) / radius);
    pos *= rotate2D(angle);
    pos += center;
    return pos;
}

vec2 movingSwirl(vec2 start, vec2 end, float angle, float radius, float frequency, vec2 pos)
{
    float phase = fract((iTime + 10.0) * frequency);
    angle *= (1.0 - cos(phase * TAU)) * 0.5;
    vec2 center = mix(start, end, phase);
    return swirl(center, angle, radius, pos);
}

vec2 swirls(vec2 pos)
{
    pos = movingSwirl(vec2( 0.0, -1.5), vec2( 0.3, 2.0),  5.0, 0.5, 0.10, pos);
    pos = movingSwirl(vec2( 0.0, -1.5), vec2(-0.3, 2.0), -4.0, 0.5, 0.11, pos);
    pos = movingSwirl(vec2( 0.2, -1.1), vec2( 0.5, 1.8),  4.5, 0.4, 0.12, pos);
    pos = movingSwirl(vec2(-0.2, -1.3), vec2(-0.4, 1.2), -3.8, 0.4, 0.13, pos);
    pos = movingSwirl(vec2( 0.1, -1.5), vec2(-0.3, 1.5),  4.7, 0.3, 0.14, pos);
    pos = movingSwirl(vec2(-0.1, -1.4), vec2( 0.4, 1.6), -3.8, 0.3, 0.15, pos);
    pos = movingSwirl(vec2( 0.0, -1.5), vec2( 0.3, 2.0),  5.0, 0.5, 0.16, pos);
    pos = movingSwirl(vec2( 0.0, -1.5), vec2(-0.3, 2.0), -4.0, 0.5, 0.17, pos);
    pos = movingSwirl(vec2( 0.2, -1.1), vec2( 0.5, 1.8),  4.5, 0.4, 0.18, pos);
    pos = movingSwirl(vec2(-0.2, -1.3), vec2(-0.4, 1.2), -3.8, 0.4, 0.19, pos);
    pos = movingSwirl(vec2( 0.1, -1.5), vec2(-0.3, 1.5),  4.7, 0.3, 0.20, pos);
    pos = movingSwirl(vec2(-0.1, -1.4), vec2( 0.4, 1.6), -3.8, 0.3, 0.21, pos);
    
    return pos;
}

float smoke(vec2 pos)
{
    pos = swirls(pos);
    return smokeBase(pos);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = 2.0 * (fragCoord.xy - iResolution.xy * 0.5) / iResolution.y;
    
    float gamma = 2.2;
    
    vec3 bg = pow(texture2D(texture0, uv * vec2(0.5, 0.7)).xyz, vec3(gamma)) * vec3(0.5, 0.5, 0.6);
    float smokeWhite = smoke(uv);
    float smokeShadow = smoke(uv + vec2(-0.15, 0.1));
    
    vec3 color = mix(bg * mix(1.0, 0.3, smokeShadow), vec3(1.0), smokeWhite);
    
    fragColor = vec4(pow(color, vec3(1.0 / gamma)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

